### 实验名称

使用Python实现KNN

### 实验目的

本实验主要使用Python的第三方库Numpy实现KNN算法。通过该实验的学习与实践，希望学生可以： 1.掌握KNN的算法原理 2.掌握math、collections、numpy等第三方包的基本使用

### 实验背景

KNN（K-NearestNeighbor，译K最近邻）分类算法是数据挖掘分类技术中最简单的方法之一，也是最常用的分类算法之一。所谓K最近邻，就是K个最近的邻居的意思，说的是每个样本都可以用它最接近的K个邻近值来代表。近邻算法就是将数据集合中每一个记录进行分类的方法 。本实验将演示使用Python的第三方库Numpy实现KNN算法，对训练样本进行建模，并对待测样本进行类别划分。

### 实验原理

K近邻（K Nearest Neighbors，KNN）算法，又称为KNN算法，是一种非常直观并且容易理解和实现的有监督分类算法。该算法的基本思想是寻找与待分类的样本在特征空间中距离最近的K个已标记样本（即K个近邻），以这些样本的标记为参考，通过投票等方式，将占比例最高的类别标记赋给待标记样本。该方法被形象地描述为“近朱者赤，近墨者黑”。

由算法的基本思想可知，KNN分类决策需要待标记样本与所有训练样本做比较，不具有显式的参数学习过程，在训练阶段仅仅是将样本保存起来，训练时间为零，可以看作直接预测。

KNN算法需要确定K值、距离度量和分类决策规则。

需要注意的是，随着K取值的不同，我们会获得不同的分类结果。如图1所示，位于中心的**╋**表示待分类样本，当K=3时，待分类样本点的近邻都为■，可判定类别为■；当K=9时，该样本的近邻中■与▲的比例为5:4，仍可判定为■；当K=13时，该样本近邻中■与▲的比例为6:9，此时，该样本被判定为▲。一般地，K值过小时，只有少量的训练样本对预测起作用，容易发生过拟合，或者受含噪声训练数据的干扰导致预测错误。反之，K值过大，过多的训练样本对预测起作用，当不同类别样本数量不均衡时，结果偏向数量占优的样本，也容易产生预测错误。实际应用中，K值一般取较小的奇数。一般以分类错误率或者平均误差等为评价标准，采用交叉验证法选取最优的K值。当K=1时，该算法又称为最近邻算法。

两个样本的距离反映的是这两个样本的相似程度。KNN算法要求数据的所有特征都可以做量化比较，若在数据特征中存在非数值的类型，必须采取手段将其量化为数值，再进行距离计算。K近邻模型的特征空间一般是n维实数向量空间。常用的距离度量为欧氏距离，也可以是一般的![公式2](./pic/公式2)距离、离散余弦距离等。不同的距离度量所确定的最近邻点是不同的，对分类的精度影响较大。

![图1 KNN算法示意图.png](./pic/图1 KNN算法示意图.png)

图1 KNN算法示意图

分类决策通常采用多数表决。当分类决策目标是最小化分类错误率时，多数表决规则等价于经验风险（即误分率）最小化：

![公式1.png](./pic/公式1.png)

其中， ![公式4](./pic/公式4)表示测试样本的特征数据； ![公式3](./pic/公式3)表示与![公式4](./pic/公式4)最邻近的K个训练数据集合，涵盖该集合的类别为![公式5](./pic/公式5);![公式6](./pic/公式6)表示![公式3](./pic/公式3)中的第i个样本，![公式7](./pic/公式7)表示这个训练样本的标记。要使得误分率最小，就要使得 ![公式8](./pic/公式8)最大，即多数表决：

​ ![公式9.png](./pic/公式9.png)

其中，![公式10](./pic/公式10)是指示函数，即当![公式11](./pic/公式11)时其值为1，否则，其值为零。

K近邻算法的优点在于：

​ 简单，易于理解，易于实现；

​ 只需保存训练样本和标记，无需估计参数，无需训练；

​ 不易受最小错误概率的影响。理论证明，最近邻的渐进错误率最坏不超过两倍的贝叶斯错误率，最好时接近或达到贝叶斯错误率。

K近邻算法的缺点在于：

​ K的选择不固定；

​ 预测结果容易受含噪声数据的影响；

​ 当样本不平衡时，新样本的类别偏向于训练样本中数量占优的类别，容易导致预测错误。

​ 具有较高的计算复杂度和内存消耗，因为对每一个待分类的文本都要计算它到全体已知样本的距离，才能求得它的K个最近邻点。

针对KNN算法的缺点，有两个主要的改进方向：提高分类效果和提高分类效率。

在经典的K近邻算法中，每个近邻对最后的决策作用都一样，而人类的直观是距离越近的作用也越大，由此产生了距离加权最近邻算法，即距离越近的样本赋予越大的权重，以此来提高分类效果。也有人根据每个类别的数目为每个类别选取不同的K值。

对于包含N个p维特征的训练集，经典KNN算法的时间复杂度为O(pN)，为了减少计算复杂度和内存消耗，提高KNN算法的分类效率，一种常用的策略是降维方法获得特征数据在某种意义上最优的低维表示，或利用特征选择方法删除对分类结果影响较小的属性，提高距离计算的运算效率。另一种常用的策略是预建立结构，通常根据训练样本之间的相对距离将训练集组织成某种形式的搜索树（例如，kd树），在计算近邻样本时，只需在搜索树的某个分支中查找，从而降低计算量。

### 实验环境

Ubuntu 18.04

Python 3.9

Numpy 1.25.2

### 建议课时

2课时

### 实验步骤

#### 1、环境准备

打开pycharm开发环境，如图2所示：

![图2 pycharm桌面快捷方式.png](./pic/图2 pycharm桌面快捷方式.png)

​ 图2 pycharm桌面快捷方式截图

之后创建新的工程，如图3所示：

![图3 pycharm启动.jpg](./pic/图3 pycharm启动.jpg)

​ 图3 创建工程方式截图

创建完工程之后创建python文件，如图4所示：

![图4 创建python文件.jpg](./pic/图4 创建python文件.jpg)

​ 图3 创建python文件方式截图

#### 2、导入所需要的包

```python
import numpy as np
from math import sqrt
from collections import Counter
```

#### 3、定义KNN函数

```python
def distance(k, X_train, Y_train, x):
    #保证K有效
    assert 1 <= k <= X_train.shape[0], "K must be valid"
    #X_train的值必须等于y_train的值
    assert X_train.shape[0] == Y_train.shape[0], "the size of X_train must equal to the size of y_train"
    #x的特征号必须等于X_train
    assert X_train.shape[1] == x.shape[0], "the feature number of x must be equal to X_train"
    #迅速计算距离
    distance = [sqrt(np.sum((x_train - x)**2)) for x_train in X_train]
    #返回距离值从小到大排序后的索引值的数组
    nearest = np.argsort(distance)
    #获取距离最小的前k个样本的标签
    topk_y = [Y_train[i] for i in nearest[:k]]
    #统计前k个样本的标签类别以及对应的频数
    votes = Counter(topk_y)
    #返回频数最多的类别
    return votes.most_common(1)[0][0]
```

#### 4、加载训练样本

```python
#使用numpy生成8个点
X_train = np.array([[1.0, 3.5],
                       [2.0, 7],
                       [3.0, 10.5],
                       [4.0, 14],
                       [5, 25],
                       [6, 30],
                       [7, 35],
                       [8, 40]])
```

#### 5、标注训练样本对应的标签

```python
#使用numpy生成8个点对应的类别
Y_train = np.array([0, 0, 0, 0, 1, 1, 1, 1])
```

#### 6、加载待测样本

```python
#使用numpy生成待分类样本点
x = np.array([8, 21])
```

#### 7、模型训练

```python
#调用distance函数并传入参数
label = distance(3, X_train, Y_train, x)
```

#### 8、显示待测样本的标签

```python
#显示待测样本点的分类结果
print(label)
```

该实验的完整代码：

```python
#导入所需要的包
import numpy as np
from math import sqrt
from collections import Counter
def distance(k, X_train, Y_train, x):
    #保证K有效
    assert 1 <= k <= X_train.shape[0], "K must be valid"
    #X_train的值必须等于y_train的值
    assert X_train.shape[0] == Y_train.shape[0], "the size of X_train must equal to the size of y_train"
    #x的特征号必须等于X_train
    assert X_train.shape[1] == x.shape[0], "the feature number of x must be equal to X_train"
    #迅速计算距离
    distance = [sqrt(np.sum((x_train - x)**2)) for x_train in X_train]
    #返回距离值从小到大排序后的索引值的数组
    nearest = np.argsort(distance)
    #获取距离最小的前k个样本的标签
    topk_y = [Y_train[i] for i in nearest[:k]]
    #统计前k个样本的标签类别以及对应的频数
    votes = Counter(topk_y)
    #返回频数最多的类别
    return votes.most_common(1)[0][0]
if __name__ == "__main__":
    #使用numpy生成8个点
    X_train = np.array([[1.0, 3.5],
                       [2.0, 7],
                       [3.0, 10.5],
                       [4.0, 14],
                       [5, 25],
                       [6, 30],
                       [7, 35],
                       [8, 40]])
    #使用numpy生成8个点对应的类别
    Y_train = np.array([0, 0, 0, 0, 1, 1, 1, 1])
    #使用numpy生成待分类样本点
    x = np.array([8, 21])
    #调用distance函数并传入参数
    label = distance(3, X_train, Y_train, x)
    #显示待测样本点的分类结果
    print(label)
```

#### 9、实验结果

以上使用Python的第三方库Numpy实现的KNN算法对待测样本进行类别划分的实验结果如下：

```markup
1
```

其代码运行的效果图如图5所示：

![图5 实验运行效果图.png](./pic/图5 实验运行效果图.png)

​ 图5 实验运行的效果图

### 实验总结

这节实验我们介绍了如何使用Python的第三方库Numpy实现KNN算法，从实验结果可以看出，通过定义ＫＮＮ函数对已知类别的样本进行训练建模，并使用训练好的模型对待测样本进行类别划分，最终给出待测样本的类别。